/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.client.aws;

import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;

public class BucketItem {
    private final String name;
    private final byte[] data;
    private final Instant lastModified;

    public String getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    private BucketItem(Builder builder) {
        this.name = builder.name;
        this.data = builder.data;
        this.lastModified = builder.lastModified;
    }

    public static Builder bucketItemBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketItem that = (BucketItem)o;
        return Objects.equals(this.name, that.name) && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.data);
    }

    public static Builder bucketItemBuilder(BucketItem copy) {
        Builder builder = new Builder();
        builder.name = copy.getName();
        Builder.access$102(builder, copy.getData());
        builder.lastModified = copy.lastModified;
        return builder;
    }

    public static final class Builder {
        private String name;
        private byte[] data;
        private Instant lastModified;

        private Builder() {
        }

        public Builder withName(String val) {
            this.name = val;
            return this;
        }

        public Builder withData(byte[] val) {
            this.data = val;
            return this;
        }

        public Builder withLastModified(Instant val) {
            this.lastModified = val;
            return this;
        }

        public Builder withLastModifiedNow() {
            return this.withLastModified(Instant.now());
        }

        public BucketItem build() {
            return new BucketItem(this);
        }

        static /* synthetic */ byte[] access$102(Builder x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }
}

