/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.otto.synapse.channel.aws.KinesisMessageLog;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.aws.KinesisEventSource;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public class KinesisEventSourceBuilder
implements EventSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisEventSourceBuilder.class);
    private static final int THREAD_COUNT = 8;
    private final ObjectMapper objectMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final KinesisClient kinesisClient;

    public KinesisEventSourceBuilder(ObjectMapper objectMapper, ApplicationEventPublisher eventPublisher, KinesisClient kinesisClient) {
        this.objectMapper = objectMapper;
        this.eventPublisher = eventPublisher;
        this.kinesisClient = kinesisClient;
    }

    public EventSource buildEventSource(String name, String streamName) {
        Objects.requireNonNull(streamName, "stream name must not be null");
        LOG.info("Building '{}' as KinesisEventSource", (Object)streamName);
        ExecutorService executorService = Executors.newFixedThreadPool(8, new ThreadFactoryBuilder().setNameFormat("kinesis-message-log-%d").build());
        KinesisMessageLog messageLog = new KinesisMessageLog(this.kinesisClient, streamName, executorService);
        return new KinesisEventSource(name, messageLog, this.eventPublisher, this.objectMapper);
    }
}

