/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource.aws;

import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.aws.CompactedKinesisEventSource;
import de.otto.synapse.eventsource.aws.KinesisEventSourceBuilder;
import de.otto.synapse.eventsource.aws.SnapshotEventSourceBuilder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactedKinesisEventSourceBuilder
implements EventSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CompactedKinesisEventSourceBuilder.class);
    private final KinesisEventSourceBuilder kinesisEventSourceBuilder;
    private final SnapshotEventSourceBuilder snapshotEventSourceBuilder;

    public CompactedKinesisEventSourceBuilder(KinesisEventSourceBuilder kinesisEventSourceBuilder, SnapshotEventSourceBuilder snapshotEventSourceBuilder) {
        this.kinesisEventSourceBuilder = kinesisEventSourceBuilder;
        this.snapshotEventSourceBuilder = snapshotEventSourceBuilder;
    }

    public EventSource buildEventSource(String name, String streamName) {
        Objects.requireNonNull(streamName, "stream name must not be null");
        LOG.info("Building '{}' as CompactingKinesisEventSource", (Object)streamName);
        return new CompactedKinesisEventSource(this.snapshotEventSourceBuilder.buildEventSource(name, streamName), this.kinesisEventSourceBuilder.buildEventSource(name, streamName));
    }
}

