/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message.aws;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import software.amazon.awssdk.services.kinesis.model.Record;

public class KinesisMessage<T>
extends Message<T> {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private static final Function<ByteBuffer, String> BYTE_BUFFER_STRING = byteBuffer -> {
        if (byteBuffer == null || byteBuffer.equals(EMPTY_BYTE_BUFFER)) {
            return null;
        }
        return StandardCharsets.UTF_8.decode((ByteBuffer)byteBuffer).toString();
    };

    public static Message<String> kinesisMessage(String shard, Duration durationBehind, Record record) {
        if (record == null) {
            return new KinesisMessage<String>(shard, durationBehind, BYTE_BUFFER_STRING);
        }
        return new KinesisMessage<String>(shard, durationBehind, record, BYTE_BUFFER_STRING);
    }

    private KinesisMessage(String shard, Duration durationBehind, Record record, Function<ByteBuffer, T> decoder) {
        super(record.partitionKey(), Header.responseHeader((ChannelPosition)ChannelPosition.of((String)shard, (String)record.sequenceNumber()), (Instant)record.approximateArrivalTimestamp(), (Duration)durationBehind), decoder.apply(record.data()));
    }

    private KinesisMessage(String shard, Duration durationBehind, Function<ByteBuffer, T> decoder) {
        super("no_key", Header.responseHeader((ChannelPosition)ChannelPosition.of((String)shard, (String)"unknown"), (Instant)Instant.MIN, (Duration)durationBehind), decoder.apply(ByteBuffer.wrap(new byte[0])));
    }
}

