/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.aws.s3;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import de.otto.edison.aws.s3.S3Service;
import de.otto.synapse.aws.s3.ProgressLogger;
import de.otto.synapse.aws.s3.SnapshotUtils;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.StartFrom;
import de.otto.synapse.configuration.aws.SnapshotProperties;
import de.otto.synapse.state.StateRepository;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotWriteService {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotWriteService.class);
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mmX").withZone(ZoneOffset.UTC);
    private static final String ZIP_ENTRY = "data";
    private static final String DATA_FIELD_NAME = "data";
    private static final String START_SEQUENCE_NUMBERS_FIELD_NAME = "startSequenceNumbers";
    private static final String SHARD_FIELD_NAME = "shard";
    private static final String SEQUENCE_NUMBER_FIELD_NAME = "sequenceNumber";
    private final S3Service s3Service;
    private final String snapshotBucketName;
    private final JsonFactory jsonFactory = new JsonFactory();

    public SnapshotWriteService(S3Service s3Service, SnapshotProperties properties) {
        this.s3Service = s3Service;
        this.snapshotBucketName = properties.getBucketName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeSnapshot(String channelName, ChannelPosition position, StateRepository<String> stateRepository) throws IOException {
        File snapshotFile = null;
        try {
            LOG.info("Start creating new snapshot");
            snapshotFile = this.createSnapshot(channelName, position, stateRepository);
            LOG.info("Finished creating snapshot file: {}", (Object)snapshotFile.getAbsolutePath());
            this.uploadSnapshot(this.snapshotBucketName, snapshotFile);
            LOG.info("Finished uploading snapshot file to s3");
        }
        finally {
            if (snapshotFile != null) {
                LOG.info("delete file {}", (Object)snapshotFile.toPath().toString());
                this.deleteFile(snapshotFile);
            }
        }
        return snapshotFile.getName();
    }

    @VisibleForTesting
    File createSnapshot(String channelName, ChannelPosition currentChannelPosition, StateRepository<String> stateRepository) throws IOException {
        File snapshotFile = SnapshotWriteService.createSnapshotFile(channelName);
        try (FileOutputStream fos = new FileOutputStream(snapshotFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ZipOutputStream zipOutputStream = new ZipOutputStream(bos);){
            ZipEntry zipEntry = new ZipEntry("data");
            zipEntry.setMethod(8);
            zipOutputStream.putNextEntry(zipEntry);
            JsonGenerator jGenerator = this.jsonFactory.createGenerator((OutputStream)zipOutputStream, JsonEncoding.UTF8);
            jGenerator.writeStartObject();
            this.writeSequenceNumbers(currentChannelPosition, jGenerator);
            jGenerator.writeArrayFieldStart("data");
            ProgressLogger processedLogger = new ProgressLogger(LOG, stateRepository.size());
            stateRepository.keySet().forEach(key -> {
                try {
                    processedLogger.incrementAndLog();
                    String entry = (String)stateRepository.get(key).get();
                    if (!"".equals(entry)) {
                        jGenerator.writeStartObject();
                        jGenerator.writeStringField(key, entry);
                        jGenerator.writeEndObject();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            jGenerator.writeEndArray();
            jGenerator.writeEndObject();
            jGenerator.flush();
            zipOutputStream.closeEntry();
        }
        catch (Exception e) {
            LOG.info("delete file {}", (Object)snapshotFile.toPath().toString());
            this.deleteFile(snapshotFile);
            throw e;
        }
        finally {
            System.gc();
        }
        return snapshotFile;
    }

    private void deleteFile(File file) {
        boolean success;
        if (file != null && !(success = file.delete())) {
            LOG.error("failed to delete snapshot {}", (Object)file.getName());
        }
    }

    private static File createSnapshotFile(String channelName) throws IOException {
        return File.createTempFile(String.format("%s%s-", SnapshotUtils.getSnapshotFileNamePrefix(channelName), dateTimeFormatter.format(Instant.now())), ".json.zip");
    }

    private void uploadSnapshot(String bucketName, File snapshotFile) {
        this.s3Service.upload(bucketName, snapshotFile);
    }

    private void writeSequenceNumbers(ChannelPosition currentChannelPosition, JsonGenerator jGenerator) throws IOException {
        jGenerator.writeArrayFieldStart(START_SEQUENCE_NUMBERS_FIELD_NAME);
        currentChannelPosition.shards().forEach(shardName -> {
            try {
                jGenerator.writeStartObject();
                jGenerator.writeStringField(SHARD_FIELD_NAME, shardName);
                if (currentChannelPosition.shard(shardName).startFrom() == StartFrom.HORIZON) {
                    jGenerator.writeStringField(SEQUENCE_NUMBER_FIELD_NAME, "0");
                } else {
                    jGenerator.writeStringField(SEQUENCE_NUMBER_FIELD_NAME, currentChannelPosition.shard(shardName).position());
                }
                jGenerator.writeEndObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        jGenerator.writeEndArray();
    }
}

