/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel.aws;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.listener.RetryListenerSupport;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.KinesisException;

public class KinesisShardIterator {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisShardIterator.class);
    static final Integer FETCH_RECORDS_LIMIT = 10000;
    private static final int RETRY_MAX_ATTEMPTS = 16;
    private static final int RETRY_BACK_OFF_POLICY_INITIAL_INTERVAL = 1000;
    private static final int RETRY_BACK_OFF_POLICY_MAX_INTERVAL = 64000;
    private static final double RETRY_BACK_OFF_POLICY_MULTIPLIER = 2.0;
    private final KinesisClient kinesisClient;
    private String id;
    private final RetryTemplate retryTemplate;
    private final AtomicBoolean stopSignal = new AtomicBoolean(false);

    public KinesisShardIterator(KinesisClient kinesisClient, String firstId) {
        this.kinesisClient = kinesisClient;
        this.id = firstId;
        this.retryTemplate = this.createRetryTemplate();
    }

    public String getId() {
        return this.id;
    }

    public void stop() {
        this.stopSignal.set(true);
    }

    public GetRecordsResponse next() {
        try {
            return (GetRecordsResponse)this.retryTemplate.execute(context -> {
                if (this.stopSignal.get()) {
                    context.setExhaustedOnly();
                }
                return this.tryNext();
            });
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private GetRecordsResponse tryNext() {
        GetRecordsResponse response = this.kinesisClient.getRecords((GetRecordsRequest)GetRecordsRequest.builder().shardIterator(this.id).limit(FETCH_RECORDS_LIMIT).build());
        this.id = response.nextShardIterator();
        return response;
    }

    private RetryTemplate createRetryTemplate() {
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(16, (Map)ImmutableMap.of(KinesisException.class, (Object)true, SdkClientException.class, (Object)true));
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(1000L);
        backOffPolicy.setMaxInterval(64000L);
        backOffPolicy.setMultiplier(2.0);
        RetryTemplate template = new RetryTemplate();
        template.registerListener((RetryListener)new LogRetryListener());
        template.setRetryPolicy((RetryPolicy)retryPolicy);
        template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        return template;
    }

    class LogRetryListener
    extends RetryListenerSupport {
        LogRetryListener() {
        }

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable t) {
            LOG.info("{}. fail to iterate on shard: {}", (Object)context.getRetryCount(), (Object)t.getMessage());
        }
    }
}

