/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.compaction.aws;

import de.otto.synapse.aws.s3.SnapshotWriteService;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.consumer.DefaultMessageConsumer;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.message.Message;
import de.otto.synapse.state.StateRepository;
import java.time.Duration;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionService {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionService.class);
    private final StateRepository<String> stateRepository;
    private final SnapshotWriteService snapshotWriteService;
    private final EventSourceBuilder eventSourceBuilder;

    public CompactionService(SnapshotWriteService snapshotWriteService, StateRepository<String> stateRepository, EventSourceBuilder eventSourceBuilder) {
        this.snapshotWriteService = snapshotWriteService;
        this.stateRepository = stateRepository;
        this.eventSourceBuilder = eventSourceBuilder;
    }

    public String compact(String channelName) {
        LOG.info("Start compacting channel {}", (Object)channelName);
        this.stateRepository.clear();
        LOG.info("Start loading entries into inMemoryCache from snapshot");
        EventSource compactingKinesisEventSource = this.eventSourceBuilder.buildEventSource("compactionSource", channelName);
        compactingKinesisEventSource.register((MessageConsumer)new DefaultMessageConsumer(".*", String.class, this.stateRepository));
        try {
            ChannelPosition currentPosition = compactingKinesisEventSource.consume(this.stopCondition());
            LOG.info("Finished updating snapshot data. StateRepository now holds {} entries.", (Object)this.stateRepository.size());
            String string = this.snapshotWriteService.writeSnapshot(channelName, currentPosition, this.stateRepository);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.stateRepository.clear();
        }
    }

    private Predicate<Message<?>> stopCondition() {
        return event -> event.getHeader().getDurationBehind().map(CompactionService::isLessThan10Seconds).orElse(true);
    }

    private static Boolean isLessThan10Seconds(Duration d) {
        return d.compareTo(Duration.ofSeconds(10L)) < 0;
    }
}

