/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.channel.aws.KinesisMessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.aws.KinesisEventSource;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public class KinesisEventSourceBuilder
implements EventSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisEventSourceBuilder.class);
    private final ObjectMapper objectMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final KinesisClient kinesisClient;
    private final MessageInterceptorRegistry interceptorRegistry;

    public KinesisEventSourceBuilder(ObjectMapper objectMapper, ApplicationEventPublisher eventPublisher, KinesisClient kinesisClient, MessageInterceptorRegistry interceptorRegistry) {
        this.objectMapper = objectMapper;
        this.eventPublisher = eventPublisher;
        this.kinesisClient = kinesisClient;
        this.interceptorRegistry = interceptorRegistry;
    }

    public EventSource buildEventSource(String name, String channelName) {
        Objects.requireNonNull(channelName, "channel name must not be null");
        LOG.info("Building '{}' as KinesisEventSource", (Object)channelName);
        KinesisMessageLogReceiverEndpoint messageLog = new KinesisMessageLogReceiverEndpoint(this.kinesisClient, this.objectMapper, channelName);
        messageLog.registerInterceptorsFrom(this.interceptorRegistry);
        return new KinesisEventSource(name, messageLog, this.eventPublisher);
    }
}

