/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderFactory;
import de.otto.synapse.endpoint.sender.aws.KinesisMessageSender;
import de.otto.synapse.translator.JsonStringMessageTranslator;
import de.otto.synapse.translator.MessageTranslator;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public class KinesisMessageSenderFactory
implements MessageSenderFactory {
    private final MessageInterceptorRegistry registry;
    private final MessageTranslator<String> messageTranslator;
    private final KinesisClient kinesisClient;

    public KinesisMessageSenderFactory(MessageInterceptorRegistry registry, ObjectMapper objectMapper, KinesisClient kinesisClient) {
        this.registry = registry;
        this.messageTranslator = new JsonStringMessageTranslator(objectMapper);
        this.kinesisClient = kinesisClient;
    }

    public MessageSenderEndpoint createSenderFor(String channelName) {
        KinesisMessageSender messageSender = new KinesisMessageSender(channelName, this.messageTranslator, this.kinesisClient);
        messageSender.registerInterceptorsFrom(this.registry);
        return messageSender;
    }
}

