/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.compaction.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.compaction.aws.SnapshotFileHelper;
import de.otto.synapse.compaction.aws.SnapshotParser;
import de.otto.synapse.compaction.aws.SnapshotReadService;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.info.SnapshotReaderNotification;
import de.otto.synapse.info.SnapshotReaderStatus;
import java.io.File;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class SnapshotEventSource
implements EventSource {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotEventSource.class);
    private final String name;
    private final String channelName;
    private final SnapshotReadService snapshotReadService;
    private final ApplicationEventPublisher eventPublisher;
    private final MessageDispatcher messageDispatcher;

    public SnapshotEventSource(String name, String channelName, SnapshotReadService snapshotReadService, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper) {
        this.name = name;
        this.channelName = channelName;
        this.snapshotReadService = snapshotReadService;
        this.eventPublisher = eventPublisher;
        this.messageDispatcher = new MessageDispatcher(objectMapper);
    }

    public String getName() {
        return this.name;
    }

    public void register(MessageConsumer<?> messageConsumer) {
        this.messageDispatcher.add(messageConsumer);
    }

    @Nonnull
    public MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    @Nonnull
    public MessageLogReceiverEndpoint getMessageLogReceiverEndpoint() {
        return null;
    }

    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public ChannelPosition consumeUntil(@Nonnull ChannelPosition startFrom, @Nonnull Instant until) {
        ChannelPosition snapshotStreamPosition;
        Instant snapshotTimestamp = null;
        try {
            this.publishEvent(SnapshotReaderStatus.STARTING, "Retrieve snapshot file from S3.", null);
            Optional<File> snapshotFile = this.snapshotReadService.retrieveLatestSnapshot(this.getChannelName());
            if (snapshotFile.isPresent()) {
                snapshotTimestamp = SnapshotFileHelper.getSnapshotTimestamp(snapshotFile.get().getName());
                this.publishEvent(SnapshotReaderStatus.STARTED, "Retrieve snapshot file from S3.", snapshotTimestamp);
                snapshotStreamPosition = new SnapshotParser().parse(snapshotFile.get(), (MessageConsumer<String>)this.getMessageDispatcher());
            } else {
                snapshotStreamPosition = ChannelPosition.fromHorizon();
            }
        }
        catch (RuntimeException e) {
            this.publishEvent(SnapshotReaderStatus.FAILED, "Failed to load snapshot from S3: " + e.getMessage(), snapshotTimestamp);
            throw e;
        }
        finally {
            LOG.info("Finished reading snapshot into Memory");
        }
        this.publishEvent(SnapshotReaderStatus.FINISHED, "Finished to load snapshot from S3.", snapshotTimestamp);
        return snapshotStreamPosition;
    }

    public void stop() {
    }

    public boolean isStopping() {
        return false;
    }

    private void publishEvent(SnapshotReaderStatus status, String message, Instant snapshotTimestamp) {
        if (this.eventPublisher != null) {
            SnapshotReaderNotification notification = SnapshotReaderNotification.builder().withSnapshotTimestamp(snapshotTimestamp).withChannelName(this.getChannelName()).withStatus(status).withMessage(message).build();
            try {
                this.eventPublisher.publishEvent((Object)notification);
            }
            catch (Exception e) {
                LOG.error("error publishing event source notification: {}", (Object)notification, (Object)e);
            }
        }
    }
}

