/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver.aws;

import com.google.common.collect.Maps;
import de.otto.synapse.channel.ChannelDurationBehind;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.endpoint.receiver.aws.KinesisShardResponse;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.MessageTranslator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class KinesisMessageLogResponse {
    private final String channelName;
    private final Map<String, KinesisShardResponse> shardResponses;

    public KinesisMessageLogResponse(List<KinesisShardResponse> shardResponses) {
        if (shardResponses.isEmpty()) {
            throw new IllegalArgumentException("Unable to create KinesisMessageLogResponse without KinesisShardResponses");
        }
        if (shardResponses.stream().map(KinesisShardResponse::getChannelName).distinct().count() > 1L) {
            throw new IllegalArgumentException("Unable to create KinesisMessageLogResponse from KinesisShardResponses returned by different message channels");
        }
        this.channelName = shardResponses.get(0).getChannelName();
        this.shardResponses = Maps.uniqueIndex(shardResponses, KinesisShardResponse::getShardName);
    }

    public String getChannelName() {
        return this.channelName;
    }

    public ChannelDurationBehind getChannelDurationBehind() {
        ChannelDurationBehind.Builder durationBehind = ChannelDurationBehind.channelDurationBehind();
        this.shardResponses.forEach((key, value) -> durationBehind.with(key, value.getDurationBehind()));
        return durationBehind.build();
    }

    public List<Message<String>> getMessages() {
        return this.shardResponses.values().stream().flatMap(response -> response.getMessages().stream()).collect(Collectors.toList());
    }

    public <P> List<Message<P>> getMessages(MessageTranslator<P> messageTranslator) {
        return this.shardResponses.values().stream().flatMap(response -> response.getMessages().stream().map(arg_0 -> ((MessageTranslator)messageTranslator).translate(arg_0))).collect(Collectors.toList());
    }

    public void dispatchMessages(MessageConsumer<String> messageConsumer) {
        this.shardResponses.values().stream().flatMap(response -> response.getMessages().stream()).forEach(messageConsumer);
    }

    public Set<String> getShardNames() {
        return this.shardResponses.values().stream().map(KinesisShardResponse::getShardName).collect(Collectors.toSet());
    }

    public Collection<KinesisShardResponse> getShardResponses() {
        return this.shardResponses.values();
    }

    public ChannelPosition getChannelPosition() {
        return ChannelPosition.channelPosition((Iterable)this.shardResponses.values().stream().map(KinesisShardResponse::getShardPosition).collect(Collectors.toList()));
    }
}

