/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.edison.aws.configuration.AwsProperties;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.aws.KinesisMessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.endpoint.sender.aws.KinesisMessageSenderEndpointFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;

@Configuration
@EnableConfigurationProperties(value={AwsProperties.class})
public class KinesisAutoConfiguration {
    private final AwsProperties awsProperties;

    @Autowired
    public KinesisAutoConfiguration(AwsProperties awsProperties) {
        this.awsProperties = awsProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={KinesisClient.class})
    public KinesisClient kinesisClient(AwsCredentialsProvider credentialsProvider) {
        System.setProperty("aws.cborEnabled", "false");
        return (KinesisClient)((KinesisClientBuilder)((KinesisClientBuilder)KinesisClient.builder().credentialsProvider(credentialsProvider)).region(Region.of((String)this.awsProperties.getRegion()))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageSenderEndpointFactory kinesisSenderEndpointFactory(MessageInterceptorRegistry registry, ObjectMapper objectMapper, KinesisClient kinesisClient) {
        return new KinesisMessageSenderEndpointFactory(registry, objectMapper, kinesisClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory(MessageInterceptorRegistry interceptorRegistry, ObjectMapper objectMapper, KinesisClient kinesisClient, ApplicationEventPublisher eventPublisher) {
        return new KinesisMessageLogReceiverEndpointFactory(interceptorRegistry, kinesisClient, objectMapper, eventPublisher);
    }
}

