/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver.aws;

import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.Message;
import de.otto.synapse.message.aws.KinesisMessage;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;

public class KinesisShardResponse {
    private final String channelName;
    private final Duration durationBehind;
    private final long runtime;
    private final ShardPosition shardPosition;
    private final List<Message<String>> messages;

    public KinesisShardResponse(String channelName, ShardPosition shardPosition, GetRecordsResponse recordsResponse, long runtime) {
        this.channelName = channelName;
        this.shardPosition = shardPosition;
        this.runtime = runtime;
        this.durationBehind = Duration.ofMillis(recordsResponse.millisBehindLatest());
        this.messages = recordsResponse.records().stream().map(record -> KinesisMessage.kinesisMessage(shardPosition.shardName(), record)).collect(Collectors.toList());
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getShardName() {
        return this.shardPosition.shardName();
    }

    public ShardPosition getShardPosition() {
        return this.shardPosition;
    }

    public Duration getDurationBehind() {
        return this.durationBehind;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public List<Message<String>> getMessages() {
        return this.messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KinesisShardResponse response = (KinesisShardResponse)o;
        return this.runtime == response.runtime && Objects.equals(this.channelName, response.channelName) && Objects.equals(this.durationBehind, response.durationBehind) && Objects.equals(this.shardPosition, response.shardPosition) && Objects.equals(this.messages, response.messages);
    }

    public int hashCode() {
        return Objects.hash(this.channelName, this.durationBehind, this.runtime, this.shardPosition, this.messages);
    }

    public String toString() {
        return "KinesisShardResponse{channelName='" + this.channelName + '\'' + ", durationBehind=" + this.durationBehind + ", runtime=" + this.runtime + ", shardPosition=" + this.shardPosition + ", messages=" + this.messages + '}';
    }
}

