/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender.aws;

import de.otto.synapse.endpoint.sender.AbstractMessageSenderEndpoint;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.MessageTranslator;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class SqsMessageSender
extends AbstractMessageSenderEndpoint {
    private final String queueUrl;
    private final SQSAsyncClient sqsAsyncClient;

    public SqsMessageSender(String channelName, String queueUrl, MessageTranslator<String> messageTranslator, SQSAsyncClient sqsAsyncClient) {
        super(channelName, messageTranslator);
        this.queueUrl = queueUrl;
        this.sqsAsyncClient = sqsAsyncClient;
    }

    protected void doSend(@Nonnull Message<String> message) {
        if (!message.getKey().isEmpty()) {
            throw new IllegalArgumentException("Unable to send messages with a message-key");
        }
        this.sqsAsyncClient.sendMessage((SendMessageRequest)SendMessageRequest.builder().queueUrl(this.queueUrl).messageBody((String)message.getPayload()).build());
    }

    protected void doSendBatch(@Nonnull Stream<Message<String>> messageStream) {
        AtomicInteger id = new AtomicInteger(0);
        this.sqsAsyncClient.sendMessageBatch((SendMessageBatchRequest)SendMessageBatchRequest.builder().queueUrl(this.queueUrl).entries((Collection)messageStream.map(message -> (SendMessageBatchRequestEntry)SendMessageBatchRequestEntry.builder().id(String.valueOf(id.getAndIncrement())).messageBody((String)message.getPayload()).build()).collect(Collectors.toList())).build());
    }
}

