/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.edison.aws.configuration.AwsProperties;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.aws.SqsMessageQueueReceiverEndpoint;
import de.otto.synapse.endpoint.sender.aws.SqsMessageSenderEndpointFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.SQSAsyncClientBuilder;

@Configuration
@EnableConfigurationProperties(value={AwsProperties.class})
public class SqsAutoConfiguration {
    private final AwsProperties awsProperties;

    @Autowired
    public SqsAutoConfiguration(AwsProperties awsProperties) {
        this.awsProperties = awsProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={SQSAsyncClient.class})
    public SQSAsyncClient sqsAsyncClient(AwsCredentialsProvider credentialsProvider) {
        return (SQSAsyncClient)((SQSAsyncClientBuilder)((SQSAsyncClientBuilder)SQSAsyncClient.builder().credentialsProvider(credentialsProvider)).region(Region.of((String)this.awsProperties.getRegion()))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public SqsMessageSenderEndpointFactory sqsSenderEndpointFactory(MessageInterceptorRegistry registry, ObjectMapper objectMapper, SQSAsyncClient sqsAsyncClient) {
        return new SqsMessageSenderEndpointFactory(registry, objectMapper, sqsAsyncClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageQueueReceiverEndpointFactory sqsReceiverEndpointFactory(MessageInterceptorRegistry registry, ObjectMapper objectMapper, SQSAsyncClient sqsAsyncClient, ApplicationEventPublisher eventPublisher) {
        return channelName -> {
            SqsMessageQueueReceiverEndpoint endpoint = new SqsMessageQueueReceiverEndpoint(channelName, sqsAsyncClient, objectMapper, eventPublisher);
            endpoint.registerInterceptorsFrom(registry);
            return endpoint;
        };
    }
}

