/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.receiver.aws.KinesisMessageLogReceiverEndpoint;
import java.time.Clock;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public class KinesisMessageLogReceiverEndpointFactory
implements MessageLogReceiverEndpointFactory {
    private final MessageInterceptorRegistry interceptorRegistry;
    private final KinesisClient kinesisClient;
    private final ObjectMapper objectMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final Clock clock;

    @Autowired
    public KinesisMessageLogReceiverEndpointFactory(MessageInterceptorRegistry interceptorRegistry, KinesisClient kinesisClient, ObjectMapper objectMapper, ApplicationEventPublisher eventPublisher) {
        this(interceptorRegistry, kinesisClient, objectMapper, eventPublisher, Clock.systemDefaultZone());
    }

    public KinesisMessageLogReceiverEndpointFactory(MessageInterceptorRegistry interceptorRegistry, KinesisClient kinesisClient, ObjectMapper objectMapper, ApplicationEventPublisher eventPublisher, Clock clock) {
        this.interceptorRegistry = interceptorRegistry;
        this.kinesisClient = kinesisClient;
        this.objectMapper = objectMapper;
        this.eventPublisher = eventPublisher;
        this.clock = clock;
    }

    public MessageLogReceiverEndpoint create(@Nonnull String channelName) {
        KinesisMessageLogReceiverEndpoint messageLog = new KinesisMessageLogReceiverEndpoint(channelName, this.kinesisClient, this.objectMapper, this.eventPublisher, this.clock);
        messageLog.registerInterceptorsFrom(this.interceptorRegistry);
        return messageLog;
    }
}

