/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender.aws;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.endpoint.sender.aws.SqsMessageSender;
import de.otto.synapse.translator.JsonStringMessageTranslator;
import de.otto.synapse.translator.MessageTranslator;
import javax.annotation.Nonnull;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;

public class SqsMessageSenderEndpointFactory
implements MessageSenderEndpointFactory {
    private final MessageInterceptorRegistry registry;
    private final MessageTranslator<String> messageTranslator;
    private final SQSAsyncClient sqsAsyncClient;
    private String messageSenderName;

    public SqsMessageSenderEndpointFactory(MessageInterceptorRegistry registry, ObjectMapper objectMapper, SQSAsyncClient sqsAsyncClient, String messageSenderName) {
        this.registry = registry;
        this.messageTranslator = new JsonStringMessageTranslator(objectMapper);
        this.sqsAsyncClient = sqsAsyncClient;
        this.messageSenderName = messageSenderName;
    }

    public MessageSenderEndpoint create(@Nonnull String channelName) {
        try {
            String queueUrl = ((GetQueueUrlResponse)this.sqsAsyncClient.getQueueUrl((GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(channelName).build()).get()).queueUrl();
            SqsMessageSender messageSender = new SqsMessageSender(channelName, queueUrl, this.messageTranslator, this.sqsAsyncClient, this.messageSenderName);
            messageSender.registerInterceptorsFrom(this.registry);
            return messageSender;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get queueUrl for channel=" + channelName + ": " + e.getMessage(), e);
        }
    }
}

