/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class SqsClientHelper {
    private final SQSAsyncClient sqsAsyncClient;

    public SqsClientHelper(SQSAsyncClient sqsAsyncClient) {
        this.sqsAsyncClient = sqsAsyncClient;
    }

    public boolean doesChannelExist(String channelName) {
        try {
            URL queueUrl = this.getQueueUrl(channelName);
            return this.getQueueUrls().contains(queueUrl);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean doesChannelExist(URL channelUrl) {
        try {
            return this.getQueueUrls().contains(channelUrl);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public List<URL> getQueueUrls() {
        try {
            ListQueuesResponse queuesResponse = (ListQueuesResponse)this.sqsAsyncClient.listQueues().get();
            return queuesResponse.queueUrls().stream().map(this::toUrl).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public URL getQueueUrl(String channelName) {
        try {
            return this.toUrl(((GetQueueUrlResponse)this.sqsAsyncClient.getQueueUrl((GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(channelName).build()).get()).queueUrl());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void createChannelIfNotExists(String channelName) {
        try {
            if (!this.doesChannelExist(channelName)) {
                this.sqsAsyncClient.createQueue((CreateQueueRequest)CreateQueueRequest.builder().queueName(channelName).build()).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void purgeQueue(String channelName) {
        try {
            if (this.doesChannelExist(channelName)) {
                URL channelUrl = this.getQueueUrl(channelName);
                this.sqsAsyncClient.purgeQueue((PurgeQueueRequest)PurgeQueueRequest.builder().queueUrl(channelUrl.toString()).build()).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void purgeQueue(URL channelUrl) {
        try {
            if (this.doesChannelExist(channelUrl)) {
                this.sqsAsyncClient.purgeQueue((PurgeQueueRequest)PurgeQueueRequest.builder().queueUrl(channelUrl.toString()).build()).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<Message> receiveMessages(String channelName, int seconds) {
        boolean abort;
        List<Message> messages;
        Instant started = Instant.now();
        do {
            messages = this.receiveMessages(channelName);
            boolean bl = abort = Duration.between(started, Instant.now()).getSeconds() > (long)seconds;
        } while (messages.isEmpty() && !abort);
        return messages;
    }

    public List<Message> receiveMessages(URL channelUrl, int seconds) {
        boolean abort;
        List<Message> messages;
        Instant started = Instant.now();
        do {
            messages = this.receiveMessages(channelUrl);
            boolean bl = abort = Duration.between(started, Instant.now()).getSeconds() > (long)seconds;
        } while (messages.isEmpty() && !abort);
        return messages;
    }

    public List<Message> receiveMessages(String queueName) {
        URL channelUrl = this.getQueueUrl(queueName);
        return this.receiveMessages(channelUrl);
    }

    public List<Message> receiveMessages(URL channelUrl) {
        try {
            ReceiveMessageResponse response = (ReceiveMessageResponse)this.sqsAsyncClient.receiveMessage((ReceiveMessageRequest)ReceiveMessageRequest.builder().waitTimeSeconds(Integer.valueOf(1)).queueUrl(channelUrl.toString()).build()).get();
            if (response.messages() != null) {
                List messages = response.messages();
                messages.forEach(message -> this.acknowledge(message.receiptHandle()));
                return messages;
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void sendMessage(String channelName, String key, String payload) {
        URL channelUrl = this.getQueueUrl(channelName);
        this.sendMessage(channelUrl, key, payload);
        try {
            SendMessageResponse sendMessageResponse = (SendMessageResponse)this.sqsAsyncClient.sendMessage((SendMessageRequest)SendMessageRequest.builder().queueUrl(channelUrl.toString()).messageAttributes(Collections.singletonMap("synapse_msg_key", MessageAttributeValue.builder().dataType("String").stringValue(key).build())).messageBody(payload).build()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void sendMessage(URL channelUrl, String key, String payload) {
        try {
            SendMessageResponse sendMessageResponse = (SendMessageResponse)this.sqsAsyncClient.sendMessage((SendMessageRequest)SendMessageRequest.builder().queueUrl(channelUrl.toString()).messageAttributes(Collections.singletonMap("synapse_msg_key", MessageAttributeValue.builder().dataType("String").stringValue(key).build())).messageBody(payload).build()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public CompletableFuture<DeleteMessageResponse> acknowledge(String receiptHandle) {
        return this.sqsAsyncClient.deleteMessage((DeleteMessageRequest)DeleteMessageRequest.builder().receiptHandle(receiptHandle).build());
    }

    public URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

