/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message.aws;

import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import software.amazon.awssdk.services.kinesis.model.Record;

public class KinesisMessage {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private static final Function<ByteBuffer, String> BYTE_BUFFER_STRING = byteBuffer -> {
        if (byteBuffer == null || byteBuffer.equals(EMPTY_BYTE_BUFFER)) {
            return null;
        }
        return StandardCharsets.UTF_8.decode((ByteBuffer)byteBuffer).toString();
    };

    public static Message<String> kinesisMessage(@Nonnull String shard, @Nonnull Record record) {
        return Message.message((String)record.partitionKey(), (Header)Header.responseHeader((ShardPosition)ShardPosition.fromPosition((String)shard, (String)record.sequenceNumber()), (Instant)record.approximateArrivalTimestamp()), (Object)BYTE_BUFFER_STRING.apply(record.data()));
    }
}

