/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.compaction.s3;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.compaction.s3.SnapshotWriteService;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.StatefulMessageConsumer;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.message.Message;
import de.otto.synapse.state.StateRepository;
import de.otto.synapse.translator.MessageCodec;
import java.time.Clock;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionService {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionService.class);
    private final StateRepository<String> stateRepository;
    private final SnapshotWriteService snapshotWriteService;
    private final EventSourceBuilder eventSourceBuilder;
    private final MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory;
    private final Clock clock;

    public CompactionService(SnapshotWriteService snapshotWriteService, StateRepository<String> stateRepository, EventSourceBuilder eventSourceBuilder, MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory) {
        this(snapshotWriteService, stateRepository, eventSourceBuilder, messageLogReceiverEndpointFactory, Clock.systemDefaultZone());
    }

    public CompactionService(SnapshotWriteService snapshotWriteService, StateRepository<String> stateRepository, EventSourceBuilder eventSourceBuilder, MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory, Clock clock) {
        this.snapshotWriteService = snapshotWriteService;
        this.stateRepository = stateRepository;
        this.eventSourceBuilder = eventSourceBuilder;
        this.messageLogReceiverEndpointFactory = messageLogReceiverEndpointFactory;
        this.clock = clock;
    }

    public String compact(String channelName) {
        LOG.info("Start compacting channel {}", (Object)channelName);
        this.stateRepository.clear();
        LOG.info("Start loading entries into inMemoryCache from snapshot");
        MessageLogReceiverEndpoint messageLog = this.messageLogReceiverEndpointFactory.create(channelName);
        EventSource compactingKinesisEventSource = this.eventSourceBuilder.buildEventSource(messageLog);
        compactingKinesisEventSource.register((MessageConsumer)new StatefulMessageConsumer(".*", String.class, this.stateRepository, MessageCodec::encode, Message::getKey));
        try {
            ChannelPosition currentPosition = (ChannelPosition)compactingKinesisEventSource.consumeUntil(Instant.now(this.clock)).get();
            LOG.info("Finished updating snapshot data. StateRepository now holds {} entries.", (Object)this.stateRepository.size());
            String string = this.snapshotWriteService.writeSnapshot(channelName, currentPosition, this.stateRepository);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.stateRepository.clear();
        }
    }
}

