/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.compaction.s3;

import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.message.Message;
import de.otto.synapse.state.StateRepository;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.TextEncoder;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class SnapshotMessageConsumer
implements MessageConsumer<String> {
    private final Pattern keyPattern = Pattern.compile(".*");
    private final StateRepository<String> stateRepository;
    private final Function<? super Message<String>, String> keyMapper = message -> message.getKey().compactionKey();
    private final BiFunction<Optional<String>, ? super Message<String>, String> payloadToStateMapper;

    public SnapshotMessageConsumer(MessageFormat messageFormat, StateRepository<String> stateRepository) {
        TextEncoder encoder = new TextEncoder(messageFormat);
        this.stateRepository = stateRepository;
        this.payloadToStateMapper = (_previousValue, message) -> encoder.apply(message);
    }

    @Nonnull
    public Class<String> payloadType() {
        return String.class;
    }

    @Nonnull
    public Pattern keyPattern() {
        return this.keyPattern;
    }

    public void accept(Message<String> message) {
        if (message.getPayload() == null) {
            this.stateRepository.remove(this.keyMapper.apply((Message<String>)message));
        } else {
            this.stateRepository.compute(this.keyMapper.apply((Message<String>)message), (_key, previousValue) -> this.payloadToStateMapper.apply((Optional<String>)previousValue, (Message<String>)message));
        }
    }
}

