/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration.aws;

import de.otto.synapse.compaction.s3.SnapshotReadService;
import de.otto.synapse.compaction.s3.SnapshotWriteService;
import de.otto.synapse.configuration.aws.S3AutoConfiguration;
import de.otto.synapse.configuration.aws.SnapshotProperties;
import de.otto.synapse.messagestore.MessageStoreFactory;
import de.otto.synapse.messagestore.SnapshotMessageStore;
import de.otto.synapse.messagestore.aws.S3SnapshotMessageStore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.services.s3.S3Client;

@Configuration
@EnableConfigurationProperties(value={SnapshotProperties.class})
@Import(value={S3AutoConfiguration.class})
public class S3SnapshotAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SnapshotReadService snapshotReadService(S3Client s3Client, SnapshotProperties snapshotProperties) {
        return new SnapshotReadService(snapshotProperties, s3Client);
    }

    @Bean
    @ConditionalOnMissingBean
    public SnapshotWriteService snapshotWriteService(S3Client s3Client, SnapshotProperties snapshotProperties) {
        return new SnapshotWriteService(s3Client, snapshotProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    MessageStoreFactory<SnapshotMessageStore> snapshotMessageStoreFactory(SnapshotReadService snapshotReadService, ApplicationEventPublisher eventPublisher) {
        return (_name, channelName) -> new S3SnapshotMessageStore("Snapshot", channelName, snapshotReadService, eventPublisher);
    }
}

