/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.compaction.s3;

import com.google.common.base.StandardSystemProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotFileHelper {
    public static final String COMPACTION_FILE_EXTENSION = ".json.zip";
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotFileHelper.class);
    private static final int ONE_MB = 0x100000;
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mmX").withZone(ZoneOffset.UTC);

    private SnapshotFileHelper() {
    }

    public static Path getTempFile(String filename) {
        return Paths.get(SnapshotFileHelper.getTempDir() + "/" + filename, new String[0]);
    }

    public static String getTempDir() {
        return System.getProperty(StandardSystemProperty.JAVA_IO_TMPDIR.key());
    }

    public static boolean existsAndHasSize(Path path, long size) {
        File file = path.toFile();
        return file.exists() && file.canRead() && file.length() == size;
    }

    public static void removeTempFiles(String filePattern) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher(String.format("glob:%s/%s", tmpDir, filePattern));
        try {
            Files.walkFileTree(Paths.get(tmpDir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        if (matcher.matches(file)) {
                            LOG.info("delete file: " + file);
                            Files.delete(file);
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("could not delete file: " + file, (Throwable)e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.error("error deleting tempfiles", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logDiskUsage() {
        File file = null;
        try {
            file = File.createTempFile("tempFileForDiskUsage", ".txt");
            float usableSpace = (float)file.getUsableSpace() / 1024.0f / 1024.0f / 1024.0f;
            float freeSpace = (float)file.getFreeSpace() / 1024.0f / 1024.0f / 1024.0f;
            LOG.info(String.format("Available DiskSpace: usable %.3f GB / free %.3f GB", Float.valueOf(usableSpace), Float.valueOf(freeSpace)));
            String tempDirContent = Files.list(Paths.get(System.getProperty("java.io.tmpdir"), new String[0])).filter(path -> path.toFile().isFile()).filter(path -> path.toFile().length() > 0x100000L).map(path -> String.format("%s %dmb", path.toString(), path.toFile().length() / 0x100000L)).collect(Collectors.joining("\n"));
            LOG.info("files in /tmp > 1mb: \n {}", (Object)tempDirContent);
        }
        catch (IOException e) {
            LOG.info("Error calculating disk usage: " + e.getMessage());
        }
        finally {
            try {
                if (file != null) {
                    LOG.info("delete file {}", (Object)file.toPath().toString());
                    Files.delete(file.toPath());
                }
            }
            catch (IOException e) {
                LOG.error("Error deleting temp file while calculating disk usage:" + e.getMessage());
            }
        }
    }

    public static String getSnapshotFileNamePrefix(String channelName) {
        return String.format("compaction-%s-snapshot-", channelName);
    }

    public static Instant getSnapshotTimestamp(String filename) {
        Pattern pattern = Pattern.compile(".*-snapshot-(.*)-[0-9]*.json.zip");
        Matcher matcher = pattern.matcher(filename);
        if (matcher.matches()) {
            String dateTimeString = matcher.group(1);
            return dateTimeFormatter.parse((CharSequence)dateTimeString, Instant::from);
        }
        throw new IllegalArgumentException("Could not parse timestamp from filename " + filename);
    }
}

