/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.compaction.s3;

import de.otto.synapse.compaction.s3.SnapshotFileHelper;
import de.otto.synapse.configuration.aws.SnapshotProperties;
import de.otto.synapse.helper.s3.S3Helper;
import java.io.File;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.S3Object;

public class SnapshotReadService {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotReadService.class);
    private final S3Helper s3Helper;
    private final String snapshotBucketName;
    private final Marker marker;
    private File forcedSnapshotFile = null;

    public SnapshotReadService(SnapshotProperties properties, S3Client s3Client) {
        this(properties, s3Client, null);
    }

    public SnapshotReadService(SnapshotProperties properties, S3Client s3Client, Marker marker) {
        this.s3Helper = new S3Helper(s3Client);
        this.snapshotBucketName = properties.getBucketName();
        this.marker = marker;
    }

    public void setSnapshotFile(File file) {
        Objects.requireNonNull(file, "file must not be null");
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("snapshot file does not exists or is not readable");
        }
        this.forcedSnapshotFile = file;
    }

    public Optional<File> retrieveLatestSnapshot(String channelName) {
        if (this.forcedSnapshotFile != null) {
            LOG.info(this.marker, "Use local Snapshot file: {}", (Object)this.forcedSnapshotFile);
            return Optional.of(this.forcedSnapshotFile);
        }
        LOG.info("Start downloading snapshot from S3");
        SnapshotFileHelper.logDiskUsage();
        Optional<File> latestSnapshot = this.getLatestSnapshot(channelName);
        if (latestSnapshot.isPresent()) {
            LOG.info(this.marker, "Finished downloading snapshot {}", (Object)latestSnapshot.get().getName());
            SnapshotFileHelper.logDiskUsage();
        } else {
            LOG.warn(this.marker, "No snapshot found.");
        }
        return latestSnapshot;
    }

    Optional<File> getLatestSnapshot(String channelName) {
        Optional<S3Object> s3Object = this.fetchSnapshotMetadataFromS3(this.snapshotBucketName, channelName);
        if (s3Object.isPresent()) {
            String latestSnapshotKey = s3Object.get().key();
            Path snapshotFile = SnapshotFileHelper.getTempFile(latestSnapshotKey);
            if (SnapshotFileHelper.existsAndHasSize(snapshotFile, s3Object.get().size())) {
                LOG.info(this.marker, "Locally available snapshot file is the same as in S3, skip download and use it: {}", (Object)snapshotFile.toAbsolutePath().toString());
                return Optional.of(snapshotFile.toFile());
            }
            SnapshotFileHelper.removeTempFiles(String.format("*-%s-snapshot-*.json.zip", channelName));
            LOG.info(this.marker, "Downloading snapshot file to {}", (Object)snapshotFile.getFileName().toAbsolutePath().toString());
            if (this.s3Helper.download(this.snapshotBucketName, latestSnapshotKey, snapshotFile)) {
                return Optional.of(snapshotFile.toFile());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    Optional<S3Object> fetchSnapshotMetadataFromS3(String bucketName, String channelName) {
        return this.s3Helper.listAll(bucketName).stream().filter(o -> o.key().startsWith(SnapshotFileHelper.getSnapshotFileNamePrefix(channelName))).filter(o -> o.key().endsWith(".json.zip")).min(Comparator.comparing(S3Object::lastModified, Comparator.reverseOrder()));
    }
}

