/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.compaction.s3;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.StopCondition;
import de.otto.synapse.compaction.s3.SnapshotMessageConsumer;
import de.otto.synapse.compaction.s3.SnapshotWriteService;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.eventsource.DefaultEventSource;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreFactory;
import de.otto.synapse.state.StateRepository;
import de.otto.synapse.translator.MessageFormat;
import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class CompactionService {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionService.class);
    private final StateRepository<String> stateRepository;
    private final SnapshotWriteService snapshotWriteService;
    private final MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory;
    private final MessageStoreFactory<? extends MessageStore> snapshotMessageStoreFactory;
    private final Clock clock;

    public CompactionService(SnapshotWriteService snapshotWriteService, StateRepository<String> stateRepository, MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory, MessageStoreFactory<? extends MessageStore> messageStoreFactory) {
        this(snapshotWriteService, stateRepository, messageLogReceiverEndpointFactory, messageStoreFactory, Clock.systemDefaultZone());
    }

    public CompactionService(SnapshotWriteService snapshotWriteService, StateRepository<String> stateRepository, MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory, MessageStoreFactory<? extends MessageStore> messageStoreFactory, Clock clock) {
        this.snapshotWriteService = snapshotWriteService;
        this.stateRepository = stateRepository;
        this.messageLogReceiverEndpointFactory = messageLogReceiverEndpointFactory;
        this.snapshotMessageStoreFactory = messageStoreFactory;
        this.clock = clock;
    }

    public String compact(String channelName, MessageFormat messageFormat, Marker marker) {
        LOG.info(marker, "Start compacting channel {} with MessageFormat {}", (Object)channelName, (Object)messageFormat);
        this.stateRepository.clear();
        LOG.info(marker, "Start loading entries from snapshot");
        MessageLogReceiverEndpoint messageLog = this.messageLogReceiverEndpointFactory.create(channelName);
        MessageStore messageStore = this.snapshotMessageStoreFactory.createMessageStoreFor(channelName);
        DefaultEventSource compactingKinesisEventSource = new DefaultEventSource(messageStore, messageLog, marker);
        compactingKinesisEventSource.register((MessageConsumer)new SnapshotMessageConsumer(messageFormat, this.stateRepository));
        LOG.info(marker, "Reading event source until either end of channel is reached or messages are younger than {}.", (Object)this.clock.instant());
        try {
            ChannelPosition currentPosition = (ChannelPosition)compactingKinesisEventSource.consumeUntil(StopCondition.endOfChannel().and(StopCondition.emptyResponse()).or(StopCondition.arrivalTimestampAfterNow((Clock)this.clock))).get();
            LOG.info(marker, "Finished updating snapshot data. StateRepository now holds {} entries.", (Object)this.stateRepository.size());
            String string = this.snapshotWriteService.writeSnapshot(channelName, currentPosition, this.stateRepository);
            return string;
        }
        catch (Exception e) {
            LOG.error(marker, "Exception during compaction.", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.stateRepository.clear();
        }
    }

    public String compact(String channelName) {
        return this.compact(channelName, MessageFormat.defaultMessageFormat(), null);
    }

    public String compact(String channelName, Marker marker) {
        return this.compact(channelName, MessageFormat.defaultMessageFormat(), marker);
    }
}

