/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.state;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;

public class StateRepository<V> {
    private ConcurrentMap<String, V> concurrentMap;

    public StateRepository(ConcurrentMap<String, V> concurrentMap) {
        this.concurrentMap = concurrentMap;
    }

    public V compute(String key, BiFunction<? super String, ? super Optional<V>, ? extends V> remappingFunction) {
        return (V)this.concurrentMap.compute(key, (? super K k, ? super V v) -> remappingFunction.apply((String)k, (Object)Optional.ofNullable(v)));
    }

    public V put(String key, V value) {
        return this.concurrentMap.put(key, value);
    }

    public void remove(String key) {
        this.concurrentMap.remove(key);
    }

    public void clear() {
        this.concurrentMap.clear();
    }

    public Optional<V> get(String key) {
        return Optional.ofNullable(this.concurrentMap.get(key));
    }

    public Set<String> keySet() {
        return this.concurrentMap.keySet();
    }

    public long size() {
        return this.concurrentMap.size();
    }
}

