/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation.messagequeue;

import com.google.common.base.Strings;
import de.otto.synapse.annotation.BeanNameHelper;
import de.otto.synapse.annotation.messagequeue.EnableMessageSenderEndpoint;
import de.otto.synapse.annotation.messagequeue.EnableMessageSenderEndpoints;
import de.otto.synapse.endpoint.sender.DelegateMessageSenderEndpoint;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

public class MessageQueueSenderEndpointBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(MessageQueueSenderEndpointBeanRegistrar.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        MultiValueMap messageQueuesAttr = metadata.getAllAnnotationAttributes(EnableMessageSenderEndpoints.class.getName(), false);
        if (messageQueuesAttr != null) {
            Object value = messageQueuesAttr.getFirst((Object)"value");
            this.registerMultipleMessageQueueSenderEndpoints(registry, (AnnotationAttributes[])value);
        } else {
            MultiValueMap messageQueueAttr = metadata.getAllAnnotationAttributes(EnableMessageSenderEndpoint.class.getName(), false);
            this.registerSingleMessageQueueSenderEndpoint(registry, (MultiValueMap<String, Object>)messageQueueAttr);
        }
    }

    private void registerMultipleMessageQueueSenderEndpoints(BeanDefinitionRegistry registry, AnnotationAttributes[] annotationAttributesArr) {
        for (AnnotationAttributes annotationAttributes : annotationAttributesArr) {
            String channelName = this.environment.resolvePlaceholders(annotationAttributes.getString("channelName"));
            String messageQueueSenderEndpointBeanName = Objects.toString(Strings.emptyToNull((String)annotationAttributes.getString("name")), BeanNameHelper.beanNameForMessageSenderEndpoint(channelName));
            if (registry.containsBeanDefinition(messageQueueSenderEndpointBeanName)) {
                throw new BeanCreationException(messageQueueSenderEndpointBeanName, String.format("messageQueueSenderEndpoint %s is already registered.", messageQueueSenderEndpointBeanName));
            }
            this.registerMessageQueueSenderEndpointBeanDefinition(registry, messageQueueSenderEndpointBeanName, channelName);
        }
    }

    private void registerSingleMessageQueueSenderEndpoint(BeanDefinitionRegistry registry, MultiValueMap<String, Object> messageQueueAttr) {
        if (messageQueueAttr != null) {
            String channelName = this.environment.resolvePlaceholders(messageQueueAttr.getFirst((Object)"channelName").toString());
            String messageSenderEndpointBeanName = Objects.toString(Strings.emptyToNull((String)messageQueueAttr.getFirst((Object)"name").toString()), BeanNameHelper.beanNameForMessageSenderEndpoint(channelName));
            if (!registry.containsBeanDefinition(messageSenderEndpointBeanName)) {
                this.registerMessageQueueSenderEndpointBeanDefinition(registry, messageSenderEndpointBeanName, channelName);
            } else {
                throw new BeanCreationException(messageSenderEndpointBeanName, String.format("MessageQueueReceiverEndpoint %s is already registered.", messageSenderEndpointBeanName));
            }
        }
    }

    private void registerMessageQueueSenderEndpointBeanDefinition(BeanDefinitionRegistry registry, String beanName, String channelName) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateMessageSenderEndpoint.class).addConstructorArgValue((Object)channelName).setDependencyCheck(3).getBeanDefinition());
        LOG.info("Registered MessageQueueSenderEndpoint {} with for channelName {}", (Object)beanName, (Object)channelName);
    }
}

