/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import de.otto.synapse.channel.ChannelType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelRegistry.class);
    private final ConcurrentMap<String, ChannelType> registeredChannels = new ConcurrentHashMap<String, ChannelType>();

    public void register(String channelName, ChannelType type) {
        this.registeredChannels.compute(channelName, (channelName1, previousType) -> {
            String check;
            String string = check = previousType != null ? previousType.name() : type.name();
            if (check.equals(type.name())) {
                LOG.info("Registered channelName {} with type {}", (Object)channelName, (Object)type);
                return type;
            }
            throw new IllegalArgumentException(String.format("Unable to register the same channel with name=%s type=%s with a different channelType. Previous type was %s", channelName1, type, previousType));
        });
    }

    @Nullable
    public ChannelType get(String channelName) {
        return (ChannelType)this.registeredChannels.get(channelName);
    }
}

