/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.endpoint.MessageInterceptor;
import de.otto.synapse.message.Message;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class InterceptorChain
implements MessageInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private final List<MessageInterceptor> interceptors = new CopyOnWriteArrayList<MessageInterceptor>();

    public ImmutableList<MessageInterceptor> getInterceptors() {
        return ImmutableList.copyOf(this.interceptors);
    }

    public void register(MessageInterceptor messageInterceptor) {
        this.interceptors.add(messageInterceptor);
    }

    @Override
    @Nullable
    public Message<String> intercept(@Nonnull Message<String> interceptedMessage) {
        Message<String> resultingMessage = interceptedMessage;
        for (MessageInterceptor interceptor : this.interceptors) {
            if (resultingMessage == null) break;
            resultingMessage = interceptor.intercept(resultingMessage);
        }
        if (resultingMessage != null) {
            LOG.debug("Intercepted message '{}' converted to {}", interceptedMessage, resultingMessage);
        } else {
            LOG.debug("Intercepted message '{}' converted to <null> - dropping message", interceptedMessage);
        }
        return resultingMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorChain chain = (InterceptorChain)o;
        return Objects.equals(this.interceptors, chain.interceptors);
    }

    public int hashCode() {
        return Objects.hash(this.interceptors);
    }
}

