/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableMap;
import de.otto.synapse.channel.ShardPosition;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Header
implements Serializable {
    private final ShardPosition shardPosition;
    private final Instant arrivalTimestamp;
    private final ImmutableMap<String, Object> attributes;

    public static Header emptyHeader() {
        return new Header(null, Instant.now(), (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    public static Header requestHeader(ImmutableMap<String, Object> attributes) {
        return new Header(null, Instant.now(), attributes);
    }

    public static Header responseHeader(ShardPosition shardPosition, Instant arrivalTimestamp, ImmutableMap<String, Object> attributes) {
        return new Header(shardPosition, arrivalTimestamp, attributes);
    }

    public static Header responseHeader(ShardPosition shardPosition, Instant arrivalTimestamp) {
        return new Header(shardPosition, arrivalTimestamp, (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    private Header(ShardPosition shardPosition, Instant approximateArrivalTimestamp, ImmutableMap<String, Object> attributes) {
        this.shardPosition = shardPosition;
        this.arrivalTimestamp = Objects.requireNonNull(approximateArrivalTimestamp);
        this.attributes = attributes;
    }

    @Nonnull
    public Optional<ShardPosition> getShardPosition() {
        return Optional.ofNullable(this.shardPosition);
    }

    @Nonnull
    public Instant getArrivalTimestamp() {
        return this.arrivalTimestamp;
    }

    @Nonnull
    public ImmutableMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey((Object)key);
    }

    @Nullable
    @JsonIgnore
    public Object getAttribute(String key) {
        return this.attributes.get((Object)key);
    }

    @Nullable
    @JsonIgnore
    public String getStringAttribute(String key) {
        return Objects.toString(this.attributes.get((Object)key), null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.shardPosition, header.shardPosition) && Objects.equals(this.arrivalTimestamp, header.arrivalTimestamp) && Objects.equals(this.attributes, header.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.shardPosition, this.arrivalTimestamp, this.attributes);
    }

    public String toString() {
        return "Header{shardPosition=" + this.shardPosition + ", arrivalTimestamp=" + this.arrivalTimestamp + ", attributes=" + this.attributes + '}';
    }
}

