/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import com.google.common.collect.ImmutableSet;
import de.otto.synapse.annotation.MessageInterceptor;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageInterceptorRegistration;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.MethodInvokingMessageInterceptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

public class MessageInterceptorBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(MessageInterceptorBeanPostProcessor.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private ConfigurableApplicationContext applicationContext;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Map<Method, Set<MessageInterceptor>> annotatedMethods = this.findMethodsAnnotatedWithMessageInterceptor(targetClass);
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                LOG.trace("No @MessageInterceptor annotations found on bean type: {}", bean.getClass());
            } else {
                this.registerMessageInterceptors(bean, beanName, annotatedMethods);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    private Map<Method, Set<MessageInterceptor>> findMethodsAnnotatedWithMessageInterceptor(Class<?> targetClass) {
        return MethodIntrospector.selectMethods(targetClass, method -> {
            Set<MessageInterceptor> consumerAnnotations = this.messageInterceptorAnnotationsOf(method);
            return !consumerAnnotations.isEmpty() ? consumerAnnotations : null;
        });
    }

    private void registerMessageInterceptors(Object bean, String beanName, Map<Method, Set<MessageInterceptor>> annotatedMethods) {
        for (Map.Entry<Method, Set<MessageInterceptor>> entry : annotatedMethods.entrySet()) {
            Method method = entry.getKey();
            MessageInterceptorRegistry registry = (MessageInterceptorRegistry)this.applicationContext.getBean(MessageInterceptorRegistry.class);
            for (MessageInterceptor interceptorAnnocation : entry.getValue()) {
                registry.register(this.registrationFor(interceptorAnnocation, this.messageInterceptorFor(bean, method)));
            }
        }
        LOG.info("{} @EventSourceConsumer methods processed on bean {} : {}'", new Object[]{annotatedMethods.size(), beanName, annotatedMethods});
    }

    private MessageInterceptorRegistration registrationFor(MessageInterceptor interceptorAnnotation, de.otto.synapse.endpoint.MessageInterceptor interceptor) {
        return new MessageInterceptorRegistration(Pattern.compile(interceptorAnnotation.channelNamePattern()), interceptor, (Set<EndpointType>)ImmutableSet.copyOf((Object[])interceptorAnnotation.endpointType()));
    }

    private Set<MessageInterceptor> messageInterceptorAnnotationsOf(Method method) {
        HashSet<MessageInterceptor> interceptorAnnotations = new HashSet<MessageInterceptor>();
        MessageInterceptor ann = (MessageInterceptor)AnnotationUtils.findAnnotation((Method)method, MessageInterceptor.class);
        if (ann != null) {
            interceptorAnnotations.add(ann);
        }
        return interceptorAnnotations;
    }

    private MethodInvokingMessageInterceptor messageInterceptorFor(Object bean, Method annotatedMethod) {
        return new MethodInvokingMessageInterceptor(bean, annotatedMethod);
    }
}

