/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.MessageInterceptorRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class MessageInterceptorRegistry {
    private final List<MessageInterceptorRegistration> registry = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<String, InterceptorChain> interceptorChainCache = new ConcurrentHashMap<String, InterceptorChain>();

    public void register(@Nonnull MessageInterceptorRegistration registration) {
        this.registry.add(registration);
        this.interceptorChainCache.clear();
    }

    @Nonnull
    public InterceptorChain getInterceptorChain(String channelName, EndpointType endpointType) {
        return this.interceptorChainCache.computeIfAbsent(channelName + "#" + endpointType.name(), key -> {
            InterceptorChain interceptorChain = new InterceptorChain();
            this.getRegistrations(channelName, endpointType).forEach(registration -> interceptorChain.register(registration.getInterceptor()));
            return interceptorChain;
        });
    }

    @Nonnull
    public ImmutableList<MessageInterceptorRegistration> getRegistrations(String channelName, EndpointType endpointType) {
        return (ImmutableList)this.registry.stream().filter(registration -> registration.isEnabledFor(channelName, endpointType)).collect(ImmutableList.toImmutableList());
    }
}

