/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.endpoint.MessageInterceptor;
import de.otto.synapse.message.Message;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class InterceptorChain
implements MessageInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private final ImmutableList<MessageInterceptor> interceptors;

    public InterceptorChain() {
        this.interceptors = ImmutableList.of();
    }

    public InterceptorChain(ImmutableList<MessageInterceptor> messageInterceptors) {
        this.interceptors = messageInterceptors;
    }

    public ImmutableList<MessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @Nullable
    public Message<String> intercept(@Nonnull Message<String> message) {
        Message<String> interceptedMessage = message;
        for (MessageInterceptor interceptor : this.interceptors) {
            if (interceptedMessage == null) break;
            interceptedMessage = interceptor.intercept(interceptedMessage);
        }
        if (interceptedMessage != null) {
            LOG.debug("Intercepted message '{}' converted to {}", message, interceptedMessage);
        } else {
            LOG.debug("Intercepted message '{}' converted to <null> - dropping message", message);
        }
        return interceptedMessage;
    }
}

