/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import de.otto.synapse.endpoint.AbstractMessageEndpoint;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.MessageTranslator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class AbstractMessageSenderEndpoint
extends AbstractMessageEndpoint
implements MessageSenderEndpoint {
    private final MessageTranslator<String> messageTranslator;

    public AbstractMessageSenderEndpoint(@Nonnull String channelName, @Nonnull MessageInterceptorRegistry interceptorRegistry, @Nonnull MessageTranslator<String> messageTranslator) {
        super(channelName, interceptorRegistry);
        this.messageTranslator = messageTranslator;
    }

    @Override
    public final <T> CompletableFuture<Void> send(@Nonnull Message<T> message) {
        Message<String> translatedMessage = this.messageTranslator.translate(message);
        Message<String> interceptedMessage = this.intercept(translatedMessage);
        if (interceptedMessage != null) {
            return this.doSend(interceptedMessage);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public final <T> CompletableFuture<Void> sendBatch(@Nonnull Stream<Message<T>> batch) {
        return this.doSendBatch(batch.map(this.messageTranslator::translate).map(this::intercept).filter(Objects::nonNull));
    }

    @Override
    @Nonnull
    public final EndpointType getEndpointType() {
        return EndpointType.SENDER;
    }

    protected CompletableFuture<Void> doSendBatch(@Nonnull Stream<Message<String>> batch) {
        return CompletableFuture.allOf((CompletableFuture[])batch.map(this::doSend).toArray(CompletableFuture[]::new));
    }

    protected abstract CompletableFuture<Void> doSend(@Nonnull Message<String> var1);
}

