/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardResponse;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.AbstractEventSource;
import de.otto.synapse.message.Message;
import de.otto.synapse.messagestore.MessageStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class DefaultEventSource
extends AbstractEventSource {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventSource.class);
    private final MessageStore messageStore;

    public DefaultEventSource(@Nonnull MessageStore messageStore, @Nonnull MessageLogReceiverEndpoint messageLog) {
        super(messageLog);
        this.messageStore = messageStore;
    }

    @Override
    @Nonnull
    public CompletableFuture<ChannelPosition> consumeUntil(@Nonnull Predicate<ShardResponse> stopCondition) {
        return ((CompletableFuture)this.consumeMessageStore().thenCompose(channelPosition -> this.getMessageLogReceiverEndpoint().consumeUntil((ChannelPosition)channelPosition, stopCondition))).handle((channelPosition, throwable) -> {
            if (throwable != null) {
                LOG.error("Failed to start consuming from EventSource {}: {}. Closing MessageStore.", new Object[]{this.getChannelName(), throwable.getMessage(), throwable});
            }
            try {
                this.messageStore.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close() MessageStore: " + e.getMessage(), (Throwable)e);
            }
            return channelPosition;
        });
    }

    private CompletableFuture<ChannelPosition> consumeMessageStore() {
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory("kinesis-eventsource-");
        return CompletableFuture.supplyAsync(() -> {
            this.messageStore.stream().forEach(message -> {
                Message<String> interceptedMessage = this.getMessageLogReceiverEndpoint().getInterceptorChain().intercept((Message<String>)message);
                if (interceptedMessage != null) {
                    this.getMessageLogReceiverEndpoint().getMessageDispatcher().accept(interceptedMessage);
                }
            });
            return this.messageStore.getLatestChannelPosition();
        }, Executors.newSingleThreadExecutor((ThreadFactory)threadFactory));
    }
}

