/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message;

import de.otto.synapse.message.Header;
import de.otto.synapse.message.Key;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Message<P>
implements Serializable {
    private final Key key;
    private final Header header;
    private final P payload;

    public static <P> Message<P> message(@Nonnull Key key, @Nullable P payload) {
        return new Message<P>(key, Header.of(), payload);
    }

    public static <P> Message<P> message(@Nonnull Key key, @Nonnull Header header, @Nullable P payload) {
        return new Message<P>(key, header, payload);
    }

    public static <P> Message<P> message(@Nonnull String key, @Nullable P payload) {
        return new Message<P>(Key.of(key), Header.of(), payload);
    }

    public static <P> Message<P> message(@Nonnull String key, @Nonnull Header header, @Nullable P payload) {
        return new Message<P>(Key.of(key), header, payload);
    }

    protected Message(@Nonnull Key key, @Nonnull Header header, @Nullable P payload) {
        this.key = key;
        this.payload = payload;
        this.header = header;
    }

    @Nonnull
    public Key getKey() {
        return this.key;
    }

    @Nullable
    public P getPayload() {
        return this.payload;
    }

    @Nonnull
    public Header getHeader() {
        return this.header;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.key, message.key) && Objects.equals(this.payload, message.payload) && Objects.equals(this.header, message.header);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.payload, this.header);
    }

    public String toString() {
        return "Message{of='" + this.key + '\'' + ", payload=" + this.payload + ", header=" + this.header + '}';
    }

    public static <P> Builder<P> builder(Class<P> payloadType) {
        return new Builder();
    }

    public static <P> Builder<P> copyOf(Message<P> message) {
        return new Builder().withKey(message.getKey()).withHeader(message.getHeader()).withPayload(message.getPayload());
    }

    public static class Builder<P> {
        private Key key = Key.of();
        private Header header;
        private P payload;

        public Builder<P> withKey(String key) {
            this.key = Key.of(key);
            return this;
        }

        public Builder<P> withKey(Key key) {
            this.key = key;
            return this;
        }

        public Builder<P> withHeader(Header header) {
            this.header = header;
            return this;
        }

        public Builder<P> withPayload(P payload) {
            this.payload = payload;
            return this;
        }

        public Message<P> build() {
            return new Message<P>(this.key, this.header, this.payload);
        }
    }
}

