/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.state;

import com.google.common.collect.ImmutableSet;
import de.otto.synapse.state.StateRepository;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapStateRepository<V>
implements StateRepository<V> {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentMapStateRepository.class);
    private ConcurrentMap<String, V> concurrentMap;

    public ConcurrentMapStateRepository(ConcurrentMap<String, V> concurrentMap) {
        this.concurrentMap = concurrentMap;
    }

    @Override
    public Optional<V> compute(String key, BiFunction<? super String, ? super Optional<V>, ? extends V> remappingFunction) {
        return Optional.ofNullable(this.concurrentMap.compute(key, (? super K k, ? super V v) -> remappingFunction.apply((String)k, (Object)Optional.ofNullable(v))));
    }

    @Override
    public Optional<V> put(String key, V value) {
        return Optional.ofNullable(this.concurrentMap.put(key, value));
    }

    @Override
    public Optional<V> remove(String key) {
        return Optional.ofNullable(this.concurrentMap.remove(key));
    }

    @Override
    public void clear() {
        this.concurrentMap.clear();
    }

    @Override
    public Optional<V> get(String key) {
        return Optional.ofNullable(this.concurrentMap.get(key));
    }

    @Override
    public ImmutableSet<String> keySet() {
        return ImmutableSet.copyOf(this.concurrentMap.keySet());
    }

    @Override
    public long size() {
        return this.concurrentMap.size();
    }

    @Override
    public void close() throws Exception {
        LOG.info("Closing StateRepository.");
        if (this.concurrentMap instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.concurrentMap)).close();
        }
    }
}

