/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.channel.ChannelDurationBehind;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardResponse;
import de.otto.synapse.message.Message;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ChannelResponse {
    private final String channelName;
    private final ImmutableList<ShardResponse> shardResponses;

    public static ChannelResponse channelResponse(String channelName, ImmutableList<ShardResponse> shardResponses) {
        return new ChannelResponse(channelName, shardResponses);
    }

    public static ChannelResponse channelResponse(String channelName, ShardResponse ... shardResponses) {
        return new ChannelResponse(channelName, (ImmutableList<ShardResponse>)(shardResponses != null ? ImmutableList.copyOf((Object[])shardResponses) : ImmutableList.of()));
    }

    private ChannelResponse(String channelName, ImmutableList<ShardResponse> shardResponses) {
        if (shardResponses.isEmpty()) {
            throw new IllegalArgumentException("Unable to create ChannelResponse without KinesisShardResponses");
        }
        this.channelName = channelName;
        this.shardResponses = shardResponses;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public ChannelDurationBehind getChannelDurationBehind() {
        ChannelDurationBehind.Builder durationBehind = ChannelDurationBehind.channelDurationBehind();
        this.shardResponses.forEach(response -> durationBehind.with(response.getShardName(), response.getDurationBehind()));
        return durationBehind.build();
    }

    public List<Message<String>> getMessages() {
        return this.shardResponses.stream().flatMap(response -> response.getMessages().stream()).collect(Collectors.toList());
    }

    public Set<String> getShardNames() {
        return this.shardResponses.stream().map(ShardResponse::getShardName).collect(Collectors.toSet());
    }

    public ImmutableList<ShardResponse> getShardResponses() {
        return this.shardResponses;
    }

    public ChannelPosition getChannelPosition() {
        return ChannelPosition.channelPosition(this.shardResponses.stream().map(ShardResponse::getShardPosition).collect(Collectors.toList()));
    }
}

