/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import com.google.common.collect.ImmutableList;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.Message;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public final class ShardResponse {
    private final Duration durationBehind;
    private final ShardPosition shardPosition;
    private final List<Message<String>> messages;

    private ShardResponse(ImmutableList<Message<String>> messages, ShardPosition shardPosition, Duration durationBehind) {
        this.shardPosition = shardPosition;
        this.messages = messages;
        this.durationBehind = durationBehind;
    }

    public static ShardResponse shardResponse(ShardPosition shardPosition, Duration durationBehind, ImmutableList<Message<String>> messages) {
        return new ShardResponse(messages, shardPosition, durationBehind);
    }

    public static ShardResponse shardResponse(ShardPosition shardPosition, Duration durationBehind, Message<String> ... messages) {
        return new ShardResponse((ImmutableList<Message<String>>)(messages != null ? ImmutableList.copyOf((Object[])messages) : ImmutableList.of()), shardPosition, durationBehind);
    }

    public String getShardName() {
        return this.shardPosition.shardName();
    }

    public ShardPosition getShardPosition() {
        return this.shardPosition;
    }

    public Duration getDurationBehind() {
        return this.durationBehind;
    }

    public List<Message<String>> getMessages() {
        return this.messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardResponse that = (ShardResponse)o;
        return Objects.equals(this.durationBehind, that.durationBehind) && Objects.equals(this.shardPosition, that.shardPosition) && Objects.equals(this.messages, that.messages);
    }

    public int hashCode() {
        return Objects.hash(this.durationBehind, this.shardPosition, this.messages);
    }

    public String toString() {
        return "ShardResponse{durationBehind=" + this.durationBehind + ", shardPosition=" + this.shardPosition + ", messages=" + this.messages + '}';
    }
}

