/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.annotation.MessageInterceptor;
import de.otto.synapse.configuration.SynapseProperties;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.message.DefaultHeaderAttr;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.HeaderAttr;
import de.otto.synapse.message.Message;
import java.time.Clock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultReceiverHeadersInterceptor {
    private final Clock clock;
    private final boolean enabled;

    public DefaultReceiverHeadersInterceptor(SynapseProperties synapseProperties) {
        this(synapseProperties, Clock.systemDefaultZone());
    }

    public DefaultReceiverHeadersInterceptor(SynapseProperties synapseProperties, Clock clock) {
        this.enabled = synapseProperties.getReceiver().getDefaultHeaders().isEnabled();
        this.clock = clock;
    }

    @Nullable
    @MessageInterceptor(endpointType={EndpointType.RECEIVER})
    public Message<String> addDefaultHeaders(@Nonnull Message<String> message) {
        Header.Builder headers = Header.copyOf(message.getHeader());
        if (this.enabled) {
            headers.withAttribute((HeaderAttr)DefaultHeaderAttr.MSG_RECEIVER_TS, this.clock.instant());
        }
        return Message.message(message.getKey(), headers.build(), message.getPayload());
    }
}

