/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableMap;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.HeaderAttr;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Header
implements Serializable {
    private final ShardPosition shardPosition;
    private final ImmutableMap<String, String> attributes;

    public static Header of() {
        return new Header(null, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public static Header of(ImmutableMap<String, String> attributes) {
        return new Header(null, attributes);
    }

    public static Header of(ShardPosition shardPosition, ImmutableMap<String, String> attributes) {
        return new Header(shardPosition, attributes);
    }

    public static Header of(ShardPosition shardPosition) {
        return new Header(shardPosition, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder copyOf(Header header) {
        return new Builder().withShardPosition(header.shardPosition).withAttributes((Map<String, String>)header.getAll());
    }

    private Header(ShardPosition shardPosition, ImmutableMap<String, String> attributes) {
        this.shardPosition = shardPosition;
        this.attributes = attributes;
    }

    @Nonnull
    public Optional<ShardPosition> getShardPosition() {
        return Optional.ofNullable(this.shardPosition);
    }

    @Nonnull
    @JsonAnyGetter
    public ImmutableMap<String, String> getAll() {
        return this.attributes;
    }

    public boolean containsKey(String key) {
        return this.attributes.containsKey((Object)key);
    }

    public boolean containsKey(HeaderAttr attr) {
        return this.containsKey(attr.key());
    }

    @Nullable
    @JsonIgnore
    public Object get(String key) {
        return this.attributes.get((Object)key);
    }

    @Nullable
    @JsonIgnore
    public Object get(HeaderAttr attr) {
        return this.get(attr.key());
    }

    @Nullable
    @JsonIgnore
    public Object get(String key, String defaultValue) {
        return this.attributes.getOrDefault((Object)key, (Object)defaultValue);
    }

    @Nullable
    @JsonIgnore
    public Object get(HeaderAttr attr, String defaultValue) {
        return this.get(attr.key(), defaultValue);
    }

    @Nullable
    @JsonIgnore
    public String getAsString(String key) {
        return Objects.toString(this.attributes.get((Object)key), null);
    }

    @Nullable
    @JsonIgnore
    public String getAsString(HeaderAttr attr) {
        return this.getAsString(attr.key());
    }

    @Nullable
    @JsonIgnore
    public String getAsString(String key, String defaultValue) {
        return Objects.toString(this.attributes.get((Object)key), defaultValue);
    }

    @Nullable
    @JsonIgnore
    public String getAsString(HeaderAttr attr, String defaultValue) {
        return this.getAsString(attr.key(), defaultValue);
    }

    @Nullable
    @JsonIgnore
    public Instant getAsInstant(String key) {
        return this.containsKey(key) ? Instant.parse((CharSequence)this.attributes.get((Object)key)) : null;
    }

    @Nullable
    @JsonIgnore
    public Instant getAsInstant(HeaderAttr attr) {
        return this.getAsInstant(attr.key());
    }

    @Nullable
    @JsonIgnore
    public Instant getAsInstant(String key, Instant defaultValue) {
        return this.containsKey(key) ? Instant.parse((CharSequence)this.attributes.get((Object)key)) : defaultValue;
    }

    @Nullable
    @JsonIgnore
    public Instant getAsInstant(HeaderAttr attr, Instant defaultValue) {
        return this.getAsInstant(attr.key(), defaultValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.shardPosition, header.shardPosition) && Objects.equals(this.attributes, header.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.shardPosition, this.attributes);
    }

    public String toString() {
        return "Header{shardPosition=" + this.shardPosition + ", attributes=" + this.attributes + '}';
    }

    public static class Builder {
        private ShardPosition shardPosition;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public Builder withShardPosition(@Nonnull ShardPosition shardPosition) {
            this.shardPosition = shardPosition;
            return this;
        }

        public Builder withAttribute(@Nonnull String key, @Nonnull String value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder withAttribute(@Nonnull HeaderAttr attr, @Nonnull String value) {
            return this.withAttribute(attr.key(), value);
        }

        public Builder withAttribute(@Nonnull String key, @Nonnull Instant value) {
            this.attributes.put(key, value.toString());
            return this;
        }

        public Builder withAttribute(@Nonnull HeaderAttr attr, @Nonnull Instant value) {
            return this.withAttribute(attr.key(), value);
        }

        public Builder withAttributes(@Nonnull Map<String, String> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public Header build() {
            return new Header(this.shardPosition, ImmutableMap.copyOf(this.attributes));
        }
    }
}

