/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.message.Message;
import de.otto.synapse.messagestore.WritableMessageStore;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CompactingInMemoryMessageStore
implements WritableMessageStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentNavigableMap<String, Message<String>> messages = new ConcurrentSkipListMap<String, Message<String>>();
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());
    private final boolean removeNullPayloadMessages;

    public CompactingInMemoryMessageStore() {
        this.removeNullPayloadMessages = true;
    }

    public CompactingInMemoryMessageStore(boolean removeNullPayloadMessages) {
        this.removeNullPayloadMessages = removeNullPayloadMessages;
    }

    @Override
    public void add(Message<String> message) {
        this.lock.writeLock().lock();
        try {
            if (message.getPayload() == null && this.removeNullPayloadMessages) {
                this.messages.remove(message.getKey().compactionKey());
            } else {
                this.messages.put(message.getKey().compactionKey(), message);
            }
            this.latestChannelPosition.updateAndGet(previous -> message.getHeader().getShardPosition().map(shardPosition -> ChannelPosition.merge(previous, shardPosition)).orElse((ChannelPosition)previous));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ChannelPosition getLatestChannelPosition() {
        return this.latestChannelPosition.get();
    }

    @Override
    public Stream<Message<String>> stream() {
        return this.messages.values().stream();
    }

    @Override
    public int size() {
        return this.messages.size();
    }
}

