/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Objects;

public final class ObjectMappers {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private static ObjectMapper SYNAPSE_OBJECT_MAPPER;

    public static ObjectMapper defaultObjectMapper() {
        return DEFAULT_OBJECT_MAPPER;
    }

    public static ObjectMapper currentObjectMapper() {
        return SYNAPSE_OBJECT_MAPPER;
    }

    public static synchronized void overrideObjectMapper(ObjectMapper objectMapper) {
        SYNAPSE_OBJECT_MAPPER = Objects.requireNonNull(objectMapper);
    }

    private ObjectMappers() {
    }

    static {
        DEFAULT_OBJECT_MAPPER.findAndRegisterModules();
        DEFAULT_OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        DEFAULT_OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        SYNAPSE_OBJECT_MAPPER = DEFAULT_OBJECT_MAPPER;
    }
}

