/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import de.otto.synapse.channel.selector.Selector;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.message.Message;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateMessageSenderEndpoint
implements MessageSenderEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateMessageSenderEndpoint.class);
    private final MessageSenderEndpoint delegate;

    public DelegateMessageSenderEndpoint(@Nonnull String channelName, @Nullable Class<? extends Selector> selector, List<MessageSenderEndpointFactory> factories) {
        MessageSenderEndpointFactory messageSenderEndpointFactory = factories.stream().filter(factory -> factory.matches(selector)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unable to create MessageSenderEndpoint for channelName=%s: no matching MessageSenderEndpointFactory found in the ApplicationContext.", channelName)));
        this.delegate = messageSenderEndpointFactory.create(channelName);
        LOG.info("Created MessageSenderEndpoint for channelName={}", (Object)channelName);
    }

    @Override
    @Nonnull
    public String getChannelName() {
        return this.delegate.getChannelName();
    }

    @Override
    @Nonnull
    public InterceptorChain getInterceptorChain() {
        return this.delegate.getInterceptorChain();
    }

    @Override
    @Nonnull
    public EndpointType getEndpointType() {
        return this.delegate.getEndpointType();
    }

    @Override
    @Nullable
    public Message<String> intercept(@Nonnull Message<String> message) {
        return this.delegate.intercept(message);
    }

    @Override
    public <T> CompletableFuture<Void> send(@Nonnull Message<T> message) {
        return this.delegate.send(message);
    }

    @Override
    public <T> CompletableFuture<Void> sendBatch(@Nonnull Stream<Message<T>> batch) {
        return this.delegate.sendBatch(batch);
    }
}

