/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.consumer;

import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.ObjectMappers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatcher
implements MessageConsumer<String> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDispatcher.class);
    private static final Pattern ACCEPT_ALL = Pattern.compile(".*");
    private final List<MessageConsumer<?>> messageConsumers;

    public MessageDispatcher() {
        this.messageConsumers = Collections.synchronizedList(new ArrayList());
    }

    public MessageDispatcher(List<MessageConsumer<?>> messageConsumers) {
        this.messageConsumers = Collections.synchronizedList(new ArrayList(messageConsumers));
    }

    public void add(MessageConsumer<?> messageConsumer) {
        this.messageConsumers.add(messageConsumer);
    }

    public List<MessageConsumer<?>> getAll() {
        return Collections.unmodifiableList(this.messageConsumers);
    }

    @Override
    @Nonnull
    public Class<String> payloadType() {
        return String.class;
    }

    @Override
    @Nonnull
    public Pattern keyPattern() {
        return ACCEPT_ALL;
    }

    @Override
    public void accept(Message<String> message) {
        LOG.debug("Accepting message={}", message);
        this.messageConsumers.stream().filter(consumer -> this.matchesKeyPattern(message, consumer.keyPattern())).forEach(consumer -> {
            try {
                Class payloadType = consumer.payloadType();
                if (payloadType.equals(String.class)) {
                    consumer.accept(message);
                } else {
                    Object payload = null;
                    if (message.getPayload() != null) {
                        payload = ObjectMappers.currentObjectMapper().readValue((String)message.getPayload(), payloadType);
                    }
                    Message<Object> tMessage = Message.message(message.getKey(), message.getHeader(), payload);
                    consumer.accept(tMessage);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    private boolean matchesKeyPattern(Message<String> message, Pattern keyPattern) {
        return keyPattern.matcher(message.getKey().compactionKey()).matches();
    }
}

