/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.message.Message;
import de.otto.synapse.messagestore.WritableMessageStore;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import net.openhft.chronicle.map.ChronicleMapBuilder;

@ThreadSafe
public class CompactingConcurrentMapMessageStore
implements WritableMessageStore {
    private static final int DEFAULT_KEY_SIZE_BYTES = 128;
    private static final double DEFAULT_VALUE_SIZE_BYTES = 512.0;
    private static final long DEFAULT_ENTRY_COUNT = 100000L;
    private final ConcurrentSkipListSet<String> compactedAndOrderedKeys = new ConcurrentSkipListSet();
    private final ConcurrentMap<String, Serializable> messages;
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());
    private final boolean removeNullPayloadMessages;

    public CompactingConcurrentMapMessageStore() {
        this(true);
    }

    public CompactingConcurrentMapMessageStore(boolean removeNullPayloadMessages) {
        this(removeNullPayloadMessages, (ConcurrentMap<String, Serializable>)ChronicleMapBuilder.of(String.class, Serializable.class).averageKeySize(128.0).averageValueSize(512.0).entries(100000L).create());
    }

    public CompactingConcurrentMapMessageStore(boolean removeNullPayloadMessages, ConcurrentMap<String, Serializable> messageMap) {
        this.messages = messageMap;
        this.removeNullPayloadMessages = removeNullPayloadMessages;
    }

    @Override
    public void add(Message<String> message) {
        String messageKey = message.getKey().compactionKey();
        if (message.getPayload() == null && this.removeNullPayloadMessages) {
            this.messages.remove(messageKey);
            this.compactedAndOrderedKeys.remove(messageKey);
        } else {
            this.messages.put(messageKey, message);
            this.compactedAndOrderedKeys.add(messageKey);
        }
        this.latestChannelPosition.updateAndGet(previous -> message.getHeader().getShardPosition().map(messageChannelPosition -> ChannelPosition.merge(previous, messageChannelPosition)).orElse((ChannelPosition)previous));
    }

    @Override
    public ChannelPosition getLatestChannelPosition() {
        return this.latestChannelPosition.get();
    }

    @Override
    public Stream<Message<String>> stream() {
        return this.compactedAndOrderedKeys.stream().map(this.messages::get).map(this::toStringMessage);
    }

    private Message<String> toStringMessage(Serializable message) {
        return (Message)message;
    }

    @Override
    public int size() {
        return this.messages.size();
    }
}

