/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Key;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.ObjectMappers;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCodec {
    public static final String SYNAPSE_MSG_FORMAT = "_synapse_msg_format";
    public static final String SYNAPSE_MSG_KEY = "_synapse_msg_key";
    public static final String SYNAPSE_MSG_COMPACTIONKEY = "compactionKey";
    public static final String SYNAPSE_MSG_PARTITIONKEY = "partitionKey";
    public static final String SYNAPSE_MSG_HEADERS = "_synapse_msg_headers";
    public static final String SYNAPSE_MSG_PAYLOAD = "_synapse_msg_payload";
    public static final Pattern V2_PATTERN = Pattern.compile("\\{\\s*\"_synapse_msg_format\"\\s*:\\s*\"v2\".+");
    private static final Logger LOG = LoggerFactory.getLogger(MessageCodec.class);
    private static final TypeReference<Map<String, String>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};

    public static String encode(Message<String> message) {
        return MessageCodec.encode(message, MessageFormat.defaultMessageFormat());
    }

    public static String encode(Message<String> message, MessageFormat messageFormat) {
        switch (messageFormat) {
            case V1: {
                return message.getPayload();
            }
            case V2: {
                return MessageCodec.encodeV2(message);
            }
        }
        throw new IllegalStateException("Unsupported MessageFormat " + (Object)((Object)messageFormat));
    }

    private static String encodeV2(Message<String> message) {
        ObjectMapper mapper = ObjectMappers.currentObjectMapper();
        try {
            ObjectNode root = mapper.createObjectNode();
            root.put(SYNAPSE_MSG_FORMAT, "v2");
            root.set(SYNAPSE_MSG_KEY, (JsonNode)MessageCodec.encodeKeysV2(message, mapper));
            root.set(SYNAPSE_MSG_HEADERS, MessageCodec.encodeHeadersV2(message, mapper));
            root.set(SYNAPSE_MSG_PAYLOAD, MessageCodec.encodePayloadV2(message, mapper));
            return root.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot encode message %s", message), e);
        }
    }

    private static ObjectNode encodeKeysV2(Message<String> message, ObjectMapper mapper) {
        ObjectNode keyNode = mapper.createObjectNode();
        keyNode.put(SYNAPSE_MSG_PARTITIONKEY, message.getKey().partitionKey());
        keyNode.put(SYNAPSE_MSG_COMPACTIONKEY, message.getKey().compactionKey());
        return keyNode;
    }

    private static JsonNode encodeHeadersV2(Message<String> message, ObjectMapper mapper) {
        return (JsonNode)mapper.convertValue(message.getHeader().getAll(), JsonNode.class);
    }

    private static JsonNode encodePayloadV2(Message<String> message, ObjectMapper mapper) throws IOException {
        Object jsonPayload;
        try {
            jsonPayload = message.getPayload() == null ? NullNode.getInstance() : mapper.readTree(message.getPayload());
        }
        catch (JsonParseException e) {
            jsonPayload = new TextNode(message.getPayload());
        }
        return jsonPayload;
    }

    public static Message<String> decode(String body) {
        return MessageCodec.decode(body, Header.builder(), Message.builder(String.class));
    }

    public static Message<String> decode(String body, Header.Builder headerBuilder, Message.Builder<String> messageBuilder) {
        switch (MessageCodec.versionOf(body)) {
            case V1: {
                return messageBuilder.withHeader(headerBuilder.build()).withPayload(body).build();
            }
            case V2: {
                try {
                    JsonNode json = MessageCodec.parseRecordBody(body);
                    MessageCodec.keyFrom(json).ifPresent(messageBuilder::withKey);
                    return messageBuilder.withHeader(headerBuilder.withAttributes(MessageCodec.attributesFrom(json)).build()).withPayload(MessageCodec.payloadFrom(json)).build();
                }
                catch (RuntimeException e) {
                    LOG.error("Exception caught while parsing record {}: {}", (Object)body, (Object)e.getMessage());
                    return messageBuilder.withHeader(headerBuilder.build()).withPayload(body).build();
                }
            }
        }
        throw new IllegalStateException("Unsupported message format: " + body);
    }

    private static MessageFormat versionOf(String body) {
        if (body != null) {
            return V2_PATTERN.matcher(body).matches() ? MessageFormat.V2 : MessageFormat.V1;
        }
        return MessageFormat.V1;
    }

    private static Map<String, String> attributesFrom(JsonNode json) {
        JsonNode headersJson = json.get(SYNAPSE_MSG_HEADERS);
        if (headersJson != null) {
            return (Map)ObjectMappers.currentObjectMapper().convertValue((Object)headersJson, MAP_TYPE_REFERENCE);
        }
        return Collections.emptyMap();
    }

    private static Optional<Key> keyFrom(JsonNode json) {
        JsonNode keyNode = json.get(SYNAPSE_MSG_KEY);
        if (keyNode == null || keyNode.isNull()) {
            return Optional.empty();
        }
        if (keyNode.isObject()) {
            String partitionKey = keyNode.get(SYNAPSE_MSG_PARTITIONKEY).textValue();
            String compactionKey = keyNode.get(SYNAPSE_MSG_COMPACTIONKEY).textValue();
            return Optional.of(Key.of(partitionKey, compactionKey));
        }
        String msg = "Unexpected json node containing " + json + ": ";
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    private static String payloadFrom(JsonNode json) {
        JsonNode payloadJson = json.get(SYNAPSE_MSG_PAYLOAD);
        if (payloadJson == null || payloadJson.isNull()) {
            return null;
        }
        if (payloadJson.isObject()) {
            return payloadJson.toString();
        }
        return payloadJson.asText();
    }

    private static JsonNode parseRecordBody(String body) {
        try {
            return ObjectMappers.currentObjectMapper().readTree(body);
        }
        catch (IOException e) {
            LOG.error("Error parsing body={} from Kinesis record: {}", (Object)body, (Object)e.getMessage());
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

