/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.WritableMessageStore;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import net.openhft.chronicle.map.ChronicleMapBuilder;

@ThreadSafe
public class CompactingConcurrentMapMessageStore
implements WritableMessageStore {
    private static final int DEFAULT_KEY_SIZE_BYTES = 128;
    private static final double DEFAULT_VALUE_SIZE_BYTES = 512.0;
    private static final long DEFAULT_ENTRY_COUNT = 100000L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentSkipListSet<String> compactedAndOrderedKeys = new ConcurrentSkipListSet();
    private final ConcurrentMap<String, TextMessage> messages;
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());
    private final boolean removeNullPayloadMessages;

    public CompactingConcurrentMapMessageStore() {
        this(true);
    }

    public CompactingConcurrentMapMessageStore(boolean removeNullPayloadMessages) {
        this(removeNullPayloadMessages, (ConcurrentMap<String, TextMessage>)ChronicleMapBuilder.of(String.class, TextMessage.class).averageKeySize(128.0).averageValueSize(512.0).entries(100000L).create());
    }

    public CompactingConcurrentMapMessageStore(boolean removeNullPayloadMessages, ConcurrentMap<String, TextMessage> messageMap) {
        this.messages = messageMap;
        this.removeNullPayloadMessages = removeNullPayloadMessages;
    }

    @Override
    public void add(TextMessage message) {
        String messageKey = message.getKey().compactionKey();
        this.lock.writeLock().lock();
        try {
            if (message.getPayload() == null && this.removeNullPayloadMessages) {
                this.messages.remove(messageKey);
                this.compactedAndOrderedKeys.remove(messageKey);
            } else {
                this.messages.put(messageKey, message);
                this.compactedAndOrderedKeys.add(messageKey);
            }
            this.latestChannelPosition.updateAndGet(previous -> message.getHeader().getShardPosition().map(messageChannelPosition -> ChannelPosition.merge(previous, messageChannelPosition)).orElse((ChannelPosition)previous));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ChannelPosition getLatestChannelPosition() {
        this.lock.readLock().lock();
        try {
            ChannelPosition channelPosition = this.latestChannelPosition.get();
            return channelPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<TextMessage> stream() {
        this.lock.readLock().lock();
        try {
            Stream<TextMessage> stream = this.compactedAndOrderedKeys.stream().map(this.messages::get);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.messages.size();
    }
}

