/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.WritableMessageStore;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CompactingInMemoryMessageStore
implements WritableMessageStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentNavigableMap<String, TextMessage> messages = new ConcurrentSkipListMap<String, TextMessage>();
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());
    private final boolean removeNullPayloadMessages;

    public CompactingInMemoryMessageStore() {
        this.removeNullPayloadMessages = true;
    }

    public CompactingInMemoryMessageStore(boolean removeNullPayloadMessages) {
        this.removeNullPayloadMessages = removeNullPayloadMessages;
    }

    @Override
    public void add(TextMessage message) {
        this.lock.writeLock().lock();
        try {
            if (message.getPayload() == null && this.removeNullPayloadMessages) {
                this.messages.remove(message.getKey().compactionKey());
            } else {
                this.messages.put(message.getKey().compactionKey(), message);
            }
            this.latestChannelPosition.updateAndGet(previous -> message.getHeader().getShardPosition().map(shardPosition -> ChannelPosition.merge(previous, shardPosition)).orElse((ChannelPosition)previous));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ChannelPosition getLatestChannelPosition() {
        this.lock.readLock().lock();
        try {
            ChannelPosition channelPosition = this.latestChannelPosition.get();
            return channelPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<TextMessage> stream() {
        this.lock.readLock().lock();
        try {
            Stream<TextMessage> stream = this.messages.values().stream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.messages.size();
    }
}

