/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.messagestore.WritableMessageStore;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryMessageStore
implements WritableMessageStore {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Deque<TextMessage> messages = new ConcurrentLinkedDeque<TextMessage>();
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());

    @Override
    public void add(TextMessage message) {
        this.lock.writeLock().lock();
        try {
            this.messages.add(message);
            this.latestChannelPosition.updateAndGet(previous -> {
                Optional<ShardPosition> optionalMessagePosition = message.getHeader().getShardPosition();
                return optionalMessagePosition.map(messagePosition -> ChannelPosition.merge(previous, ChannelPosition.channelPosition(messagePosition))).orElse((ChannelPosition)previous);
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ChannelPosition getLatestChannelPosition() {
        this.lock.readLock().lock();
        try {
            ChannelPosition channelPosition = this.latestChannelPosition.get();
            return channelPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Stream<TextMessage> stream() {
        this.lock.readLock().lock();
        try {
            Stream<TextMessage> stream = this.messages.stream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.messages.size();
    }
}

